'use strict'

entityRegistry['module']['cubeField'] = {
    extendedInfo: {
        displayName: 'Cube Field',
        displayGroup: '3D Effects',
    },
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'minX', displayName: 'Min X', type: 'int', defaultValue: -2},
        { paramName: 'maxX', displayName: 'Max X', type: 'int', defaultValue: +2},
        { paramName: 'minY', displayName: 'Min Y', type: 'int', defaultValue: -2},
        { paramName: 'maxY', displayName: 'Max Y', type: 'int', defaultValue: +2},
        { paramName: 'minZ', displayName: 'Min Z', type: 'int', defaultValue: -2},
        { paramName: 'maxZ', displayName: 'Max Z', type: 'int', defaultValue: +2},
        { paramName: 'yMove', displayName: 'Y Move', type: 'float', defaultValue: 0},
        { paramName: 'spread', displayName: 'Spread', type: 'float', defaultValue: 1},
        { paramName: 'minSize', displayName: 'Min Size', type: 'float', defaultValue: 0},
        { paramName: 'maxSize', displayName: 'Max Size', type: 'float', defaultValue: 1},
        { paramName: 'position', displayName: 'Position', type: 'float3', defaultValue: [0, 0, 0]},
        { paramName: 'diffuse', displayName: 'Diffuse', type: 'color', defaultValue: [1, 0, 0]},
        { paramName: 'emissive', displayName: 'Emissive', type: 'color', defaultValue: [0, 0, 1]},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                minX,
                maxX,
                minY,
                maxY,
                minZ,
                maxZ,
                yMove,
                spread,
                minSize,
                maxSize,
                position,
                diffuse,
                emissive,
            } = { ...config }

            const colorBuffer = renderer.getCurrentBuffer('color')
            const depthBuffer = renderer.getCurrentBuffer('depth')
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')

            const model = getModel('default')

            const ft = frameTime * yMove
            const ofs = ft % 1

            const transMat = m4.translation(position[0], position[1], position[2])
            const worldMat = transMat

            const material = renderer.getPaletteId(diffuse, emissive)
            for (let z = maxX; z >= minX; --z) {
                    // const c = (z + 3) / 7
                // const material = renderer.getPaletteId([c*2,1,1], [0,0,0])
                for (let yy = minY; yy <= maxY; ++yy) {
                    const y = yy - ofs
                    for (let x = minZ; x <= maxZ; ++x) {
                        const scale = lerp(minSize, maxSize, Math.abs(noise.simplex3(x + frameTime*.1, y*.2, z)))
                        const transMat = m4.translation(x*spread, y*spread, z*spread)
                        const scaleMat = m4.scaling(scale, scale, scale)
                        const modelMat = m4.multiply(transMat, scaleMat)
                        renderer.drawModel(model, m4.multiply(worldMat, modelMat), colorBuffer, depthBuffer, brightnessBuffer, material)
                    }
                }
            }
        }
    }
}
